#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include "rand.h"


void init_rand() {   
	  
	srand ((unsigned) time (NULL));   
	
}   


// flips coin with probability p
int flip(double p) {

	double random = 0.0;

	if ((((float)rand()) / RAND_MAX) < p) {
	
	
		return 1;
	
	} else {
	
		return 0;
	}
}

// Integer Uniform distribution [Low, High]
int random_number(int low, int high) {

	return low + rand() % (high - low + 1);
}

// Real Uniform distribution [0, 1]
double uniform01() {   

	return (double)(((double) rand ()) / ((double) RAND_MAX));   
}   
  
// Normal distribution N(0,1)   
double normal01() {  
  
	static int flag = 0;  
	static double x1;  
	double u1, u2, v1, v2, square;   
	double r;   
  
	if (flag == 0) {  
  
		do {   
			  
			u1 = uniform01();   
			u2 = uniform01();   
		  
			v1 = 2.0 * u1 - 1.0;   
			v2 = 2.0 * u2 - 1.0;   
			  
			r = v1 * v1 + v2 * v2;   
			  
		} while (r >= 1.0 || r == 0.0);   
  
		flag = 1;  
		square = sqrt(-2.0 * log(r) / r);  
		x1 = v1 * square;  
  
		return v2 * square;  
		  
	} else {  
  
		flag = 0;  
		return x1;  
	}  
}
