#include "mutation.h"
#include "evaluation.h"
#include "ga.h"
#include <math.h>



void random_mutation(double individual[], int pop_size, int ind_size, vect_domain bounds, double p_mt){

	int pos;

	for(pos = 0; pos < ind_size; pos++){

		if(flip(p_mt) == TRUE)
			individual[pos] = bounds[pos].min + (uniform01()*(bounds[pos].max - bounds[pos].min));
	}
}

#define MAX_TRY 5

void sigma_mutation(double individual[], int pop_size, int ind_size, vect_domain bounds, double p_mt, double sigma)
{
	int pos, conta;
	double new_val, ni;

	for(pos = 0; pos < ind_size; pos++)
	{
		if(flip(p_mt) == TRUE)
		{
		
			conta=0;
			
			do{
				ni = normal01();
				new_val = individual[pos] + sigma*(bounds[pos].max-bounds[pos].min)*ni;

				conta++;
				if(conta > MAX_TRY)
				{	
					new_val = bounds[pos].min + (uniform01()*(bounds[pos].max - bounds[pos].min));
					break;
				}
			}while(new_val < bounds[pos].min || new_val > bounds[pos].max);
			
			individual[pos] = new_val;
			
		
		}
	}
}


void apply_mutation(p_ind population, int pop_size, int ind_size, double p_mt, int type, vect_domain bounds, double sigma) {

	int i;

	for (i = 0; i < pop_size; i++)
	{
		switch(type)
		{
				case 0: random_mutation(population[i].genes, pop_size, ind_size, bounds, p_mt); break;
				case 1: sigma_mutation(population[i].genes, pop_size, ind_size, bounds, p_mt, sigma); break;
				default: printf("Invalid mutation type\n"); break;
			}

		}
}
