#ifndef _GA_H
#define _GA_H

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <sys/types.h>

#define FALSE			0                  // truth values
#define TRUE			1

#define OUTPUT_FILE		"stats.txt"	   // filename for runs output
#define OUTPUT_BEST		"best.txt"	   // filename for best solutions
#define INPUT_FILE		"parameters.txt"   // filename for input settings


#define SHRINK		0

// Setting of log files 
#define LOG_BOUNDS	1
#define LOG_EVAL	1

// Sets console printing information (1: Replicates stats.txt file to standard output; 0: No writing to standard output)
#define CONSOLE_PRINTING	1

#define PREC	1E-6


#define NO_INIT					-5   // uninitialized values

typedef struct domain domain, *vect_domain;

struct domain {

	double min;	
	double max;	
	double gap;
};

// individual
typedef struct individual ind, *p_ind;

struct individual {

	double *genes;
	double fitness;		// fitness value
};

#endif

