#include "stats.h"
#include "utils.h"
#include <string.h>
#include <math.h>

int last_print;

void update_all_time_best(ind best, p_ind all_time_best, int ind_size, int dir)
{
	int i;
	FILE *bestfile;
	
	if(dir == 1)
	{
		if(best.fitness > all_time_best->fitness)
		{
			copia_ind(&best, all_time_best, ind_size);
			if ((bestfile = fopen ("best.txt", "w")) == NULL){
				printf("\nerror: can't open file for best individual.\n");
				exit(0);
			}
			for(i = 0; i < ind_size; i++)
			{
				fprintf(bestfile, "%12.12f\n", best.genes[i]);
			}
			fprintf(bestfile, "\nFitness: %12.12f\n", best.fitness);
			fclose(bestfile);
		}
	}
	else
	{
		if(best.fitness < all_time_best->fitness)
		{
			copia_ind(&best, all_time_best, ind_size);
			if ((bestfile = fopen ("best.txt", "w")) == NULL){
				printf("\nerror: can't open file for best individual.\n");
				exit(0);
			}
			for(i = 0; i < ind_size; i++)
			{
				fprintf(bestfile, "%12.12f\n", best.genes[i]);
			}
			fprintf(bestfile, "\nFitness: %12.12f\n", best.fitness);
			fclose(bestfile);
		}
	}
}



// statistics output for a single generation

void stats(p_ind population, int generation, int evals, int pop_size, ind best,
	   int ind_size, int print) {

	int i, j;
	double average = 0.0;
	FILE *output;

	if(print!=1)
		return;

	for (i = 0; i < pop_size; i++) 
	{
		average += population[i].fitness;
	}

	if(print==1)
	{
		output=fopen(OUTPUT_FILE, "at");
		fprintf (output, "%d\t%d\t%12.12f\t%12.12f\t", evals, generation, average / pop_size, best.fitness);
		fputc('\n', output);
		fclose(output);
		if(CONSOLE_PRINTING == 1)
		{
			printf ("%d\t%d\t%12.12f\t%12.12f\t", evals, generation, average / pop_size, best.fitness);
			putchar('\n');
		}
	}
}


void avg_stats(int runs, int exec_time, int dir)
{
	//int total_iter;
	FILE *fil, *out;
	int i, j;
	char out_nome[50];
	double avg_fit, best_fit, sigma, best, worst;
	int gen, evals, num_best;

	struct res tab[MAX_LIN];

	fil = fopen(OUTPUT_FILE, "rt");
	if(!fil)
	{
		return;
	}

	strcpy(out_nome, "avg_");
	strcat(out_nome, OUTPUT_FILE);
	out = fopen(out_nome, "wt");

	for(i=0; i<runs; i++){

		fscanf(fil, " run %*d");

		if(i==0)
			fprintf(out, "Last lines\n");

		j = 0;

		while(fscanf(fil, " %d %d %lf %lf", &evals, &gen, &avg_fit, &best_fit) == 4){

			if(i==0){

				tab[j].gen = gen;
				tab[j].evals = evals;
				tab[j].avg_fit = avg_fit;
				tab[j].best_fit = best_fit;
			}else{

				tab[j].gen += gen;
				tab[j].evals += evals;
				tab[j].avg_fit += avg_fit;
				tab[j].best_fit += best_fit;
			}

			j++;

			if(j >= MAX_LIN){

				fclose(fil);
				fprintf(out, "\nToo many lines in in stats.txt file\n");
				fclose(out);
				return;
			}
		}

		fprintf(out, "%10d%10d\t%12.12f\t%12.12f\n", evals, gen, avg_fit, best_fit);

		if(dir == 1){

			if(i==0){

				best = best_fit;
				worst = best_fit;
				num_best = 1;
			}else{

				if(best_fit > best){

					best = best_fit;
					num_best = 1;
				}
				else if (best_fit == best)
					num_best++;
				else if(best_fit < worst)
					worst = best_fit;
			}
		}
		else{

			if(i==0)
			{

				best = best_fit;
				worst = best_fit;
				num_best = 1;
			}
			else
			{
				if(fabs(best_fit-best) > PREC)
				{
					if(best_fit < best)
					{
						best = best_fit;
						num_best = 1;
					}
					else if(best_fit > worst)
						worst = best_fit;
				}
				else
				{
					num_best++;
					if(best_fit < best)
						best = best_fit;
				}
			}
		}
	}

	fprintf(out, "\nEvolution average results\n");
	for(i=0; i<j; i++)
	{

		fprintf(out, "%10d%10d\t%12.12f\t%12.12f\n", tab[i].evals/runs, tab[i].gen/runs, tab[i].avg_fit/runs, tab[i].best_fit/runs);

	}

	fprintf(out, "\nBest: %12.12f (found in %d runs)\tWorst: %12.12f\n", best, num_best, worst);

	int h, m, seg;

	seg = exec_time%60;
	exec_time = exec_time/60;
	m = exec_time%60;
	h = exec_time/60;

	fprintf(out, "\nExecution time: %d:%d:%d\n", h, m, seg);
	fclose(fil);
	fclose(out);
}
























