

#include "ga.h"
#include "rand.h"
#include "evaluation.h"
#include "selection.h"
#include "crossover.h"
#include "mutation.h"
#include "stats.h"
#include "utils.h"

#include <time.h>
#include <stdlib.h>

#define reading reading_

void reading(int *particles);

extern int last_print;

double min_valor(double a, double b)
{
	if(a<b)
		return a;
	else
		return b;
}

double max_valor(double a, double b)
{
	if(a<b)
		return b;
	else
		return a;
}


void update_bounds(p_ind pop, vect_domain bounds, int pop_size, int n, vect_domain backup, int gen)
{
	double *min, *max;
	int i, j, update_min, update_max;
	FILE *f;
	
	min = malloc(sizeof(double)*n);
	max = malloc(sizeof(double)*n);
	
	for(j=0; j<n; j++)
		max[j] = min[j] = pop[0].genes[j];
	
	for(i=1; i<pop_size; i++)
		for(j=0; j<n; j++)
		{
			if(pop[i].genes[j] < min[j])
				min[j] = pop[i].genes[j];
			if(pop[i].genes[j] > max[j])
				max[j] = pop[i].genes[j];
		}
	
	for(j=0; j<n; j++)
	{
		update_min = update_max = 0;
		
		if(bounds[j].min > min[j]+PREC)
		{
			update_min = 1;
			bounds[j].min = min[j];
		}
		if(bounds[j].max+PREC < max[j])
		{
			update_max = 1;
			bounds[j].max = max[j];
		}
		
		if(SHRINK)
		{
			if(update_min==1 && update_max==0)
				bounds[j].max = max_valor(max[j], bounds[j].min+bounds[j].gap);
			else if(update_min==0 && update_max==1)
				bounds[j].min = min_valor(min[j], bounds[j].max-bounds[j].gap);
			else if(update_min==0 && update_max==0 && bounds[j].max-bounds[j].min > bounds[j].gap+PREC)
			{
				update_min = update_max = 1;
				bounds[j].min = min_valor(backup[j].min, min[j]);
				bounds[j].max = max_valor(max[j], bounds[j].min+bounds[j].gap);
			}
		}
		
		if(LOG_BOUNDS && (update_min || update_max))
		{
			f = fopen("log_bounds.txt", "a");
			fprintf(f, "Gen %d: Variable %d Interval (%.5f) -> [%.5f, %.5f]\n", gen, j+1, bounds[j].max-bounds[j].min, bounds[j].min, bounds[j].max);
			fclose(f);
		}
		
	}
	
	free(min);
	free(max);
}




void ga(int evaluations, int pop_size, int N, double p_cx, double blx_alpha, double p_mt, int elite, int size_k,
	int cx_type, int mutation_type, double sigma, p_ind all_time_best, vect_domain bounds, int dir, vect_domain backup) {

	int generation = 1, max_generation = (int)(evaluations / pop_size);
	int current_evaluations = 0;		// current generation
	ind best, new_best, dummy;
	p_ind population;		        // population
	p_ind new_population, temp;
	int last_evals;
	int print;
	static int flag=0;
	int i, j;
	FILE *f;


	// make and evaluate population
	population = make_population(pop_size, bounds, N);

	best.genes = malloc(sizeof(double) * N);
	new_best.genes = malloc(sizeof(double) * N);

	current_evaluations += evaluate_pop(population, pop_size, N, bounds, generation);
	update_bounds(population, bounds, pop_size, N, backup, generation);

	dummy = get_best(population, pop_size, dir);
	copia_ind(&dummy, &best, N);

	
	if(flag==0)
	{
		flag=1;
		copia_ind(&best, all_time_best,N);
	}
	else
		update_all_time_best(best, all_time_best, N, dir);

	stats(population, generation, current_evaluations, pop_size, best, N, 1);

	last_evals = current_evaluations;

	// allocates memory for individuals (to generate the new population)
	new_population = malloc(sizeof(ind) * pop_size);

	for(i = 0; i < pop_size; i++){

		new_population[i].genes = malloc(sizeof(double) * N);
	}

	// evolution cycle
	do {

		generation++;

		// tournament selection
		tournament_selection(population, new_population, pop_size, size_k, dir, N);

		// applies genetic operators
		apply_crossover(new_population, pop_size, N, p_cx, cx_type, blx_alpha, bounds, dir);
		apply_mutation(new_population, pop_size, N, p_mt, mutation_type, bounds, sigma);

		// evaluate populations
		current_evaluations += evaluate_pop(new_population, pop_size, N, bounds, generation);
		update_bounds(population, bounds, pop_size, N, backup, generation);

		temp = population;
		population = new_population;
		new_population = temp;

		// Get current best
		dummy = get_best(population, pop_size, dir);
		copia_ind(&dummy, &new_best, N);

		if(elite){

			if(dir == 1){

				if(new_best.fitness < best.fitness)
				{
					apply_elite(population, pop_size, best, dir, N);
				}
				else if(new_best.fitness > best.fitness)
				{
					copia_ind(&new_best, &best, N);
				}
			}
			else{

				if(new_best.fitness > best.fitness)
				{
					apply_elite(population, pop_size, best, dir, N);
				}
				else if(new_best.fitness < best.fitness)
				{
					copia_ind(&new_best, &best, N);
				}
			}
		}

		update_all_time_best(best, all_time_best, N, dir);

		// output
		if ((current_evaluations < 100) || ((current_evaluations < 1000) && (current_evaluations - last_evals > 100)) || (current_evaluations - last_evals > 250))
		{
			print=1;
			last_evals = current_evaluations;
		}
		else
			print=0;

		stats(population, generation, current_evaluations, pop_size, best, N, print);


	} while(current_evaluations < evaluations);


	if(LOG_BOUNDS)
	{
		f = fopen("log_bounds.txt", "a");
		fprintf(f, "\nFinal bounds:\n");
		for(j=0; j<N; j++)
			fprintf(f, "Var %d [%.5f, %.5f]\n", j+1, bounds[j].min, bounds[j].max);
		fprintf(f, "\n");
		fclose(f);	
	}

	for(i = 0; i < pop_size; i++){
		free(population[i].genes);
		free(new_population[i].genes);
	}
	

	free(population);
	free(new_population);
	free(best.genes);
	free(new_best.genes);
}


void run_ga(int runs, int evaluations, int pop_size, int N, double p_cx, double blx_alpha, double p_mt, int elite,
	    int size_k, int cx_type, int mutation_type, double sigma, vect_domain bounds, int dir) {

	int run;	                 // current run
	ind all_time_best;      	// best individual found for all RUNS
	
	FILE *output;
	time_t t1, t2;

		
	vect_domain backup = malloc(sizeof(domain)*N);

	int i, j;

	for(j=0; j<N; j++)
		backup[j] = bounds[j];
	

	all_time_best.genes = malloc(sizeof(double) * N);
	all_time_best.fitness = -1.0;

	output = fopen(OUTPUT_FILE, "wt");
	fclose(output);

	if(LOG_BOUNDS)
	{
		output = fopen("log_bounds.txt", "w");
		fclose(output);
	}

	if(LOG_EVAL)
	{
		output = fopen("log_eval.txt", "w");
		fclose(output);
	}
	
	init_rand();


	(void) time(&t1);

	// single GA run
	for (run = 1; run <= runs; run++) {

		// header
		output = fopen(OUTPUT_FILE, "at");

		printf("run %d\n", run);

		last_print = 0;
		fprintf(output, "run %d\n", run);
		fclose(output);
	
		if(LOG_EVAL)
		{
			output = fopen("log_eval.txt", "a");
			fprintf(output, "\nrun %d\n", run);
			fclose(output);
		}
		
		if(LOG_BOUNDS)
		{
			output = fopen("log_bounds.txt", "a");
			fprintf(output, "run %d\nInitial bounds:\n", run);
		}
		
		
		for(j=0; j<N; j++)
		{
			bounds[j] = backup[j];
			if(LOG_BOUNDS)
				fprintf(output, "Var %d [%.5f, %.5f]\n", j+1, bounds[j].min, bounds[j].max);
		}
		if(LOG_BOUNDS)
		{
			fprintf(output, "\n");
			fclose(output);	
		}
	
		ga(evaluations, pop_size, N, p_cx, blx_alpha, p_mt, elite, size_k,
			cx_type, mutation_type, sigma, &all_time_best, bounds, dir, backup);
	}

	(void) time(&t2);

	avg_stats(runs, t2-t1, dir);
	free(bounds);
	free(backup);
	free(all_time_best.genes);
}


// main function
int main(int argc, char **argv)
{

	FILE * input;			
	int     runs,			// number of runs
		evaluations,		// number of generations
		pop_size,		// population size
		elite,			// elistist strategy? (0 = no; 1 = yes)
		size_k,			// tournament selection size
	    mutation_type,          // mutation operator
	    cx_type,                // crossover operator
	    dir,
	    i, j, 
		N, particles;
	float   p_cx,			// crossover rate
		blx_alpha,
		sigma,
		p_mt;				// mutation rate
		char st[200];
		

	// read settings for GA and run it
	if ((input = fopen(INPUT_FILE, "rt")) != NULL) 
	{

		// reads from file
		fscanf(input, " runs: %d", &runs); fgets(st, 200, input);
		fscanf(input, " evaluations: %d", &evaluations); fgets(st, 200, input);
		fscanf(input, " population: %d", &pop_size); fgets(st, 200, input);
		fscanf(input, " crossover rate: %f", &p_cx); fgets(st, 200, input);
		fscanf(input, " blx_alpha: %f", &blx_alpha); fgets(st, 200, input);
		fscanf(input, " mutation rate: %f", &p_mt); fgets(st, 200, input);
		fscanf(input, " elitism: %d", &elite); fgets(st, 200, input);
		fscanf(input, " tournament size: %d", &size_k); fgets(st, 200, input);
		fscanf(input, " crossover: %d", &cx_type); fgets(st, 200, input);
		fscanf(input, " mutation: %d", &mutation_type); fgets(st, 200, input);
		fscanf(input, " sigma: %f", &sigma); fgets(st, 200, input);
		fscanf(input, " N: %d", &particles); fgets(st, 200, input);
		fscanf(input, " direction: %d", &dir); fgets(st, 200, input);

		N = particles*6;
		
		vect_domain bounds = malloc(sizeof(domain)*N);

		for(i = 0; i < 6; i++)
		{
			fscanf(input, " min: %lf", &bounds[i].min); fgets(st, 200, input);
			fscanf(input, " max: %lf", &bounds[i].max); fgets(st, 200, input);
			bounds[i].gap = bounds[i].max - bounds[i].min;
		}
		
		fclose(input);

		for(i = 1; i < particles; i++)
		{
			for(j=0; j<6; j++)
			{
				bounds[6*i+j].min = bounds[j].min;
				bounds[6*i+j].max = bounds[j].max;
				bounds[6*i+j].gap = bounds[6*i+j].max - bounds[6*i+j].min;
			}
		}

		reading(&particles);

		run_ga(runs, evaluations, pop_size, N, p_cx, blx_alpha, p_mt, elite, size_k,
		       cx_type, mutation_type, sigma, bounds, dir);
	} 
	else
	{
		printf("\nSettings not found.\n");
	}

	return 0;
}

