#include <math.h>
#include "evaluation.h"

// Fortran interface
#define eval_f eval_f_
#define object_f object_f_

#define STEP	0.1

void eval_f(double *a, double *b, int *x);
void object_f(double *a, double *b, int *x);


int jump_out(double g[], vect_domain bounds, int n)
{
	int i;
	double gap;
	
	for(i=0; i<n; i++)
	{
		gap = bounds[i].max-bounds[i].min;
		if(g[i]<(bounds[i].min-gap*STEP) || g[i]>(bounds[i].max+gap*STEP))
			return 1;
	}
	return 0;
}


// Evaluates population of individuals


int evaluate_pop (p_ind population, int pop_size, int ind_size, vect_domain bounds, int gen){

	int evaluations = 0;
	int i, j;
	double *temp;
	FILE *f;
	
	int k;
		
	temp = malloc(sizeof(double)*ind_size);


	for(i = 0; i < pop_size; i++)
	{
	
		for(j=0; j<ind_size; j++)
			temp[j] = population[i].genes[j];
	
		eval_f(population[i].genes, &population[i].fitness, &ind_size);

		if(jump_out(population[i].genes, bounds, ind_size) == 1)
		{
			if(LOG_EVAL)
			{
				f = fopen("log_eval.txt", "a");
				fprintf(f, "\n\nGen %d:\nBefore local optimization:\n", gen);
				for(j=0; j<ind_size; j++)
					fprintf(f, "%.12f  ", temp[j]);
				
				fprintf(f, "\nLocal optimization out of bounds. Energy: %.12f\n", population[i].fitness);
				for(j=0; j<ind_size; j++)
					fprintf(f, "%.12f  ", population[i].genes[j]);
				fclose(f);
			}
			
			//It does not push variables back into defined bounds
			
		}
		evaluations++;
	}
	
	
	free(temp);

	return evaluations;
}
