#include "utils.h"
#include "evaluation.h"

#include <stdlib.h>


void copia_ind(p_ind or, p_ind dest, int ind_size)
{
	int i;

	dest->fitness = or->fitness;
	for(i=0; i<ind_size; i++)
		dest->genes[i] = or->genes[i];
}

void bounds_control(p_ind population, int pop_size, int ind_size, vect_domain bounds){

	int i, j;
	int flag = 0;

	for(i = 0; i < pop_size; i++){

		for(j = 0; j < ind_size; j++){

			if(population[i].genes[j] > bounds[j].max){

				population[i].genes[j] = bounds[j].max;
				flag = 1;
			}else if(population[i].genes[j] < bounds[j].min){

				population[i].genes[j] = bounds[j].min;
				flag = 1;
			}
		}
	}
}

p_ind make_population(int pop_size, vect_domain bounds, int ind_size)
{

	int j, i, k;
	p_ind new_population;

	// allocates memory for individuals
	new_population = malloc(sizeof(ind) * pop_size);

	for(i = 0; i < pop_size; i++)
	{
		new_population[i].genes = malloc(sizeof(double) * ind_size);
	}

	// make individual
	for (i = 0; i < pop_size; i++) 
	{
		j=0;
		while(j < ind_size){
			new_population[i].genes[j] = bounds[j].min + (uniform01()*(bounds[j].max - bounds[j].min));
			j++;
		}
		new_population[i].fitness = 0.0;
	}

	// return new population
	return new_population;
}
















