! Copyright (C) 2010 J.L. Llanio-Trujillo, J.M.C. Marques, F.B. Pereira
!
! read the GA solution vector from --> best.txt 
! and writes the Lab. Cartesians q to file --> Lab_cartesians.xyz
program transform  
implicit none
integer :: i,j,nsite,nrb,isite
double precision :: energy
double precision, allocatable :: qrb(:,:),rbc(:,:),q(:,:),derivs_rbc(:,:)
character (80) :: scratch
character (2) :: scratch2

open(5,file="parameters.txt",status="old")
open(10,file="qrb.txt",status="old")
open(20,file="best.txt",status="old")
open(7,file="Lab_cartesians.xyz",status="unknown")
! read number of rigid bodies (water molecules)
do i=1,11
  read(5,*)scratch
enddo
read(5,*)scratch2,nrb
!read number of sites for each rigid body
read(10,*)nsite
print*,'NSITE, NRB= ',nsite,nrb
!nsite=4  !number of sites
!nrb=15   !number of rigid bodies (water molecules)

allocate (qrb(3*nsite,nrb),rbc(6,nrb))

allocate (q(3*nsite,nrb),derivs_rbc(6,nrb))

!body-frame (rigid body frame) referenced Cartesian coords. for the sites
do j=1,nsite
   read(10,*)(qrb(i,1),i=3*j-2,3*j)
enddo
print*,'qrbs:'
do i=1,3*nsite
print*,qrb(i,1)
enddo
print*

!copy qrb coordinates from one rigid-body to all rigid-bodies of the cluster
do j=2,nrb
 do i=1,nsite
   qrb(3*i-2,j)=qrb(3*i-2,1)
   qrb(3*i-1,j)=qrb(3*i-1,1)
   qrb(3*i,j)=qrb(3*i,1)
 enddo
enddo

! read the solution vector
do j=1,nrb
  do i=1,6
    read(20,*)rbc(i,j)
  enddo
enddo

!calculate the Lab. frame Cartesian coords. --> q 
      call rigidxyz(qrb,rbc,nsite,nrb,q)


! write q in Molden format
!      write(7,*)nrb*nsite   !write the dummy atom
      write(7,*)nrb*(nsite-1)   !don't write the dummy atom
      write(7,*)
      do i=1,nrb
          write(6,'(3f16.8)')(q(isite,i),isite=1,3*nsite)
         do isite=1,nsite
          if(isite==1)then
           write(7,'(A1,1x,3f16.8)')'O',q(3*isite-2,i),q(3*isite-1,i),q(3*isite,i)
          else if(isite==2 .or. isite==3)then
           write(7,'(A1,1x,3f16.8)')'H',q(3*isite-2,i),q(3*isite-1,i),q(3*isite,i)
!          else                                                              
!           write(7,'(A1,1x,3f16.8)')'X',q(3*isite-2,i),q(3*isite-1,i),q(3*isite,i)  !X dummy
          endif
         enddo
      enddo


! Just to check the rigid body derivs. (derivs_rbc): they should be ~ EPS !!!
      call  gradrgd (q,qrb,rbc,nsite,nrb,energy,derivs_rbc)

write(*,*)"******** derivs of the Intermolecular Potential  w.r.t. opt. params ********"
      do i = 1, nrb
          write(*,'(6f15.10)')(derivs_rbc(j,i),j=1,6)
      end do
write(*,*)"******** derivs of the Intermolecular Potential  w.r.t. opt. params ********"

      write(6,*)'Energy (kcal/mol) =',energy
      write(6,*)'Energy (kJ/mol) =',energy*4.184d0

end program transform
