#include "selection.h"
#include "utils.h"

ind get_best(p_ind population, int pop_size, int dir) {

	int i;				// actual individual
	ind best = population[0];

	if(dir == 1){

		for (i = 1; i < pop_size; i++){

			if(population[i].fitness > best.fitness)
				best = population[i];
		}
	}
	else{

		for (i = 1; i < pop_size; i++){

			if(population[i].fitness < best.fitness)
				best = population[i];
		}
	}

	return best;
}


// return best individual
int get_worst(p_ind population, int pop_size, int dir) {

	int i;		// actual individual
	int worst = 0;

	if(dir == 1){

		for (i = 1; i < pop_size; i++) {

			if (population[i].fitness < population[worst].fitness) {
				worst = i;
			}
		}
	}
	else{

		for (i = 1; i < pop_size; i++) {

			if (population[i].fitness > population[worst].fitness) {
				worst = i;
			}
		}
	}

	return worst;
}


// replaces a random individual with the best from previous generation
void apply_elite(p_ind population, int pop_size, ind best, int dir, int ind_size) {

	copia_ind(&best, population+get_worst(population, pop_size, dir), ind_size);
}


// tournament selection
void tournament_selection(p_ind population, p_ind new_population, int pop_size, int size_k, int dir, int ind_size) {

	int i, j,				// actual positions
		index,				// random individual
		winner;				// individual chosen by tournament



	// make new population with tournament winners
	for (i = 0; i < pop_size; i++) {

		// chose individual after tournament of size K
		winner = random_number(0, pop_size-1);

		for (j = 1; j < size_k; j++) {

			index = random_number(0, pop_size-1);

			if(dir == 1){
				if (population[index].fitness > population[winner].fitness)
					winner = index;
			}
			else{
				if (population[index].fitness < population[winner].fitness)
					winner = index;
			}
		}

		copia_ind(population+winner, new_population+i, ind_size);

	}
}

